-- Name: BSU_changeCoverEvent
-- Author: Chissel

BSU_changeCoverEvent = {}

local BSU_changeCoverEvent_mt = Class(BSU_changeCoverEvent, Event)
InitEventClass(BSU_changeCoverEvent, "BSU_changeCoverEvent")

function BSU_changeCoverEvent.emptyNew()
	local self = Event.new(BSU_changeCoverEvent_mt)

	return self
end

function BSU_changeCoverEvent.new(bunkerSilo, fillType)
	local self = BSU_changeCoverEvent.emptyNew()
	self.bunkerSilo = bunkerSilo
    self.fillType = fillType

	return self
end

function BSU_changeCoverEvent:readStream(streamId, connection)
    self.bunkerSilo = NetworkUtil.readNodeObject(streamId)
    self.fillType = streamReadUInt16(streamId)

	self:run(connection)
end

function BSU_changeCoverEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.bunkerSilo)
    streamWriteUInt16(streamId, self.fillType)
end

function BSU_changeCoverEvent:run(connection)
	self.bunkerSilo:changeCover(self.fillType)

	if not connection:getIsServer() then
        g_server:broadcastEvent(BSU_changeCoverEvent.new(self.bunkerSilo, self.fillType), false)
	end
end