Financing_Farm = {}

function Financing_Farm:saveToXMLFile(xmlFile, key)

    if self.financing == nil then self.financing = {} end

    xmlFile:setSortedTable(key .. ".financing.finance", self.financing, function (index, financing)
        xmlFile:setString(index .. "#date", financing.date)
        xmlFile:setFloat(index .. "#amount", financing.amount)
        xmlFile:setFloat(index .. "#amountPaid", financing.amountPaid)
        xmlFile:setInt(index .. "#length", financing.length)
        xmlFile:setString(index .. "#vehicle", financing.vehicle)
        xmlFile:setBool(index .. "#paid", financing.paid)
    end)

end

Farm.saveToXMLFile = Utils.appendedFunction(Farm.saveToXMLFile, Financing_Farm.saveToXMLFile)

function Financing_Farm:loadFromXMLFile(superFunc, xmlFile, key)

    local returnValue = superFunc(self, xmlFile, key)

    self.financing = {}

    xmlFile:iterate(key .. ".financing.finance", function (_, financingKey)
        local financingTable = {
            date = xmlFile:getString(financingKey .. "#date", "1-1"),
            amount = xmlFile:getFloat(financingKey .. "#amount", 0),
            amountPaid = xmlFile:getFloat(financingKey .. "#amountPaid", 0),
            length = xmlFile:getInt(financingKey .. "#length", 6),
            vehicle = xmlFile:getString(financingKey .. "#vehicle", "0"),
            paid = xmlFile:getBool(financingKey .. "#paid", true)
        }

        table.insert(self.financing, financingTable)
    end)

    return returnValue

end

Farm.loadFromXMLFile = Utils.overwrittenFunction(Farm.loadFromXMLFile, Financing_Farm.loadFromXMLFile)

function Financing_Farm:writeStream(streamId, connection)

    if self.financing == nil then
        streamWriteUInt16(streamId, 0)
    else
        streamWriteUInt16(streamId, #self.financing or 0)
        for _, entry in pairs(self.financing) do
            streamWriteString(streamId, entry.date)
            streamWriteFloat32(streamId, entry.amount)
            streamWriteFloat32(streamId, entry.amountPaid)
            streamWriteInt8(streamId, entry.length)
            streamWriteString(streamId, entry.vehicle)
            streamWriteBool(streamId, entry.paid)
        end
    end

end

Farm.writeStream = Utils.appendedFunction(Farm.writeStream, Financing_Farm.writeStream)

function Financing_Farm:readStream(streamId, connection)

    local tableLength = streamReadUInt16(streamId)
    self.financing = {}

    if tableLength > 0 then

        for i=1, tableLength do

            local entryDate = streamReadString(streamId)
            local entryAmount = streamReadFloat32(streamId)
            local entryAmountPaid = streamReadFloat32(streamId)
            local entryLength = streamReadInt8(streamId)
            local entryVehicle = streamReadString(streamId)
            local entryPaid = streamReadBool(streamId)

            local newEntry = {
                date = entryDate,
                amount = entryAmount,
                amountPaid = entryAmountPaid,
                length = entryLength,
                vehicle = entryVehicle,
                paid = entryPaid
            }

            table.insert(self.financing, newEntry)

        end
    end

end

Farm.readStream = Utils.appendedFunction(Farm.readStream, Financing_Farm.readStream)

function Financing_Farm:periodChanged()

    local financing = self.financing
    local env = g_currentMission.environment
    local period = env.currentPeriod
    local year = env.currentYear

    if financing ~= nil then

        for _, entry in ipairs(financing) do

            if entry.paid then continue end

            local entryPeriod = 1
            local entryYear = 1
            local amountPaid = entry.amountPaid
            local amount = entry.amount
            local interest = 1.05

            for a, b in string.gmatch(entry.date, "(%w+)-(%w+)") do
                entryPeriod = tonumber(a)
                entryYear = tonumber(b)
            end

            local totalPeriods = (12 * year) + period -- 18
            local finishedPeriods = (12 * entryYear) + entryPeriod -- 14 15 16 17 18 .. 19

            if totalPeriods >= finishedPeriods + entry.length and amountPaid >= amount * 0.99 then
                entry.paid = true
                continue
            end

            local monthlyCost = (amount - amountPaid) / math.max((finishedPeriods + entry.length) - totalPeriods, 1)

            if self:getBalance() < monthlyCost then
                local vId = entry.vehicle
                local vSystem = g_currentMission.vehicleSystem
                if vId ~= nil and totalPeriods >= finishedPeriods + entry.length - 1 and vSystem.vehicleByUniqueId[vId] ~= nil then
                    local v = vSystem.vehicleByUniqueId[vId]
                    if v ~= nil then
                        local storeItem = g_storeManager:getItemByXMLFilename(v.configFileName)
                        g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_CRITICAL, string.format(g_i18n:getText("financing_vehicleRepossessed"), tostring(storeItem.name)))
                        v:delete(false)
                        entry.paid = true
                    end
                else
                    entry.amount = entry.amount + (((amount - amountPaid) * interest) - (amount - amountPaid))
                    g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_CRITICAL, g_i18n:getText("financing_monthlyPaymentMissed"))
                    g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_CRITICAL, string.format(g_i18n:getText("financing_monthlyPaymentMissed_newRemaining"), g_i18n:formatMoney(entry.amount - amountPaid, 2, true, true)))
                end
            else

                if self.isServer then
                    g_currentMission:addMoneyChange(0 - monthlyCost, self.farmId, MoneyType.SHOP_VEHICLE_BUY, true)
                    self:changeBalance(0 - monthlyCost, MoneyType.SHOP_VEHICLE_BUY)
                    entry.amountPaid = entry.amountPaid + monthlyCost
                else
                    g_client:getServerConnection():sendEvent(MoneyChangeEvent.new(0 - monthlyCost, MoneyType.SHOP_VEHICLE_BUY, farmIndex))
                end
                if entry.amountPaid >= entry.amount * 0.99 then entry.paid = true end

            end

        end

        for a, b in ipairs(financing) do
            if b.paid == true then
                table.remove(financing, a)
                break
            end
        end

    end

end

Farm.periodChanged = Utils.appendedFunction(Farm.periodChanged, Financing_Farm.periodChanged)